// TEMPERATURE CONTROL WITH THE SENSOR LM35. DEFRAN24

#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
Adafruit_SSD1306 display(128,32,&Wire,20);
int up=9;
int dw=6;
int rel=2;
int mon=13;
int t;
int s;

void setup() 
{
  pinMode(mon, OUTPUT);
  pinMode(up, OUTPUT);
  pinMode(dw, OUTPUT);
  pinMode(rel, OUTPUT);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C); // Address 0x3C (60 DECIMAL)
  display.display();
  display.clearDisplay();
  Serial.begin(9600); 
}

void loop() 
{
  s=analogRead(A1);
  t=analogRead(A0);
  Serial.println(t);
  if (t>111 & t<115) digitalWrite(mon,HIGH); // LED Zero
  else digitalWrite(mon,LOW);
  display.display();
  display.clearDisplay(); 
  display.setTextSize(1);
  display.setTextColor(BLACK, WHITE);       // FONDO BLANCO
  display.setCursor(0,0);
  display.print("   LM35 TEMPERATURE  ");
  display.drawLine(0,10,126,10,WHITE);      // LINE X,Y,WIDTH, Y FIN
  display.setTextColor(WHITE);
  display.setCursor(4,14);
  display.print("Setting Deg.: ");
  if (s>=109) s=map(s,113,306,  0,150);
  else s=map(s,0,113, -55,0);               // Setting
  display.print(s);
  display.print(" .C"); 
  display.setCursor(4,24);
  display.print("Celsius Deg.: ");
  if (t>=109) t=map(t,113,306, 0,150);     // Temperature
  else t=map(t,0,113,-55,0); 
  display.print(t);
  display.print(" .C"); 
  display.display();
  if (t>s) {digitalWrite(up,HIGH); digitalWrite (rel, LOW);} // HEATER
  else digitalWrite(up,LOW);
  if (t<s) {digitalWrite(dw,HIGH); digitalWrite (rel, HIGH);} // HEATER
  else digitalWrite(dw,LOW);
  delay(100);
}



